// hashDouble.java
// demonstracja tablicy rozproszonej z podwjnym rozpraszaniem
// aby uruchomi program: C:>java HashDoubleApp (wersja angielska)
// aby skompilowa wersj polsk: C>javac hashDouble.java
// po kompilacji:         C>java HashDoubleApp
import java.io.*;
////////////////////////////////////////////////////////////////
class DataItem
   {                                 // (moe mie wicej danych)
   private int iData;                // element danych (klucz)
//--------------------------------------------------------------
   public DataItem(int ii)           // konstruktor
      { iData = ii; }
//--------------------------------------------------------------
   public int getKey()
      { return iData; }
//--------------------------------------------------------------
   }  // end class DataItem
////////////////////////////////////////////////////////////////
class HashTable
   {
   private DataItem[] hashArray;     // tablica rozproszona
   private int arraySize;
   private DataItem nonItem;         // do usuwania elementw
// -------------------------------------------------------------
   HashTable(int size)               // konstruktor
      {
      arraySize = size;
      hashArray = new DataItem[arraySize];
      nonItem = new DataItem(-1);    // klucz elementu usunitego to -1
      }
// -------------------------------------------------------------
   public void displayTable()
      {
      System.out.print("Tablica: ");
      for(int j=0; j<arraySize; j++)
         {
         if(hashArray[j] != null)
            System.out.print(hashArray[j].getKey()+ " ");
         else
            System.out.print("** ");
         }
      System.out.println("");
      }
// -------------------------------------------------------------
   public int hashFunc1(int key)
      {
      return key % arraySize;
      }
// -------------------------------------------------------------
   public int hashFunc2(int key)
      {
      // niezerowa, mniejsza ni rozmiar tablicy, rna od hF1
      // rozmiar tablicy musi by liczb niepodzieln przez 5, 4, 3 i 2
      return 5 - key % 5;
      }
// -------------------------------------------------------------
                                     // wstaw DataItem
   public void insert(int key, DataItem item)
   // (zakadamy, e tablica nie jest pena)
      {
      int hashVal = hashFunc1(key);  // oblicz warto indeksu dla klucza
      int stepSize = hashFunc2(key); // oblicz wielko kroku
                                     // powtarzaj do pustej lub -1
      while(hashArray[hashVal] != null &&
                      hashArray[hashVal].getKey() != -1)
         {
         hashVal += stepSize;        // dodaj wielko kroku
         hashVal %= arraySize;       // jeli trzeba, przejd na pocztek tablicy
         }
      hashArray[hashVal] = item;     // wstaw element
      }  // end insert()
// -------------------------------------------------------------
   public DataItem delete(int key)   // usu DataItem
      {
      int hashVal = hashFunc1(key);      // oblicz warto indeksu dla klucza
      int stepSize = hashFunc2(key);     // oblicz wielko kroku

      while(hashArray[hashVal] != null)  // powtarzaj do pustej,
         {                               // czy klucz zosta znaleziony?
         if(hashArray[hashVal].getKey() == key)
            {
            DataItem temp = hashArray[hashVal]; // zapisz element danych
            hashArray[hashVal] = nonItem;       // usu element
            return temp;                        // zwr element
            }
         hashVal += stepSize;            // dodaj wielko kroku
         hashVal %= arraySize;           // jeli trzeba, przejd na pocztek tablicy
         }
      return null;                   // elementu nie znaleziono
      }  // end delete()
// -------------------------------------------------------------
   public DataItem find(int key)     // znajd element o okrelonym kluczu
   // (zakadamy, e tablica nie jest pena)
      {
      int hashVal = hashFunc1(key);      // oblicz warto indeksu dla klucza
      int stepSize = hashFunc2(key);     // oblicz wielko kroku

      while(hashArray[hashVal] != null)  // powtarzaj do pustej,
         {                               // czy klucz zosta znaleziony?
         if(hashArray[hashVal].getKey() == key)
            return hashArray[hashVal];   // tak, zwr element
         hashVal += stepSize;            // dodaj wielko kroku
         hashVal %= arraySize;           // jeli trzeba, przejd na pocztek tablicy
         }
      return null;                   // elementu nie znaleziono
      }
// -------------------------------------------------------------
   }  // end class HashTable
////////////////////////////////////////////////////////////////
class HashDoubleApp
   {
   public static void main(String[] args) throws IOException
      {
      int aKey;
      DataItem aDataItem;
      int size, n;
                                  // pobierz rozmiary
      System.out.print("Wprowad rozmiar tablicy rozproszonej: ");
      size = getInt();
      System.out.print("Wprowad pocztkow liczb elementw: ");
      n = getInt();
                                  // utwrz tablic
      HashTable theHashTable = new HashTable(size);

      for(int j=0; j<n; j++)      // wstaw dane
         {
         aKey = (int)(java.lang.Math.random() * 2 * size);
         aDataItem = new DataItem(aKey);
         theHashTable.insert(aKey, aDataItem);
         }

      while(true)                 // cz interakcyjna
         {
         System.out.print("Wprowad pierwsz liter  ");
         System.out.print("Poka, Wstaw, Usu, or Znajd: ");
         char choice = getChar();
         switch(choice)
            {
            case 'p':
               theHashTable.displayTable();
               break;
            case 'w':
               System.out.print("Wprowad warto klucza: ");
               aKey = getInt();
               aDataItem = new DataItem(aKey);
               theHashTable.insert(aKey, aDataItem);
               break;
            case 'u':
               System.out.print("Wprowad warto klucza: ");
               aKey = getInt();
               theHashTable.delete(aKey);
               break;
            case 'z':
               System.out.print("Wprowad warto klucza: ");
               aKey = getInt();
               aDataItem = theHashTable.find(aKey);
               if(aDataItem != null)
                  System.out.println("Znaleziono " + aKey);
               else
                  System.out.println("Nie znaleziono " + aKey);
               break;
            default:
               System.out.print("Wcisne niewaciwy klawisz\n");
            }  // end switch
         }  // end while
      }  // end main()
//--------------------------------------------------------------
   public static String getString() throws IOException
      {
      InputStreamReader isr = new InputStreamReader(System.in);
      BufferedReader br = new BufferedReader(isr);
      String s = br.readLine();
      return s;
      }
//--------------------------------------------------------------
   public static char getChar() throws IOException
      {
      String s = getString();
      return s.charAt(0);
      }
//-------------------------------------------------------------
   public static int getInt() throws IOException
      {
      String s = getString();
      return Integer.parseInt(s);
      }
//--------------------------------------------------------------
   }  // end class HashDoubleApp
////////////////////////////////////////////////////////////////
